﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;          // added to include serial ports

namespace RELAY_MODULE_TEST
{
    public partial class Form1 : Form
    {
        static SerialPort BTooth;
        char[] SerBuf = new char[70];
        byte module_version;
        enum modules { NONE, BT004 = 30 };
        int module_id = (int) modules.NONE;

        public Form1()
        {
            byte x;
            InitializeComponent();
            BTooth = new SerialPort();
            string[] comportnames = new string[100];
            comportnames = SerialPort.GetPortNames();
            var sortedList = comportnames.OrderBy(port => Convert.ToInt32(port.Replace("COM", string.Empty)));
            foreach (string port in sortedList)
            {
                comboBox_comport.Items.Add(port);                      // places each "COMx" name into combobox
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            char x;
            System.Diagnostics.Stopwatch stopwatch;
            string[] temp = new string[4];
            switch (module_id) //module specific code
            {
                case (int)modules.BT004:
                    textBox_status.Text = "BT004 found";
                    SerBuf[0] = ':';    //get supply voltage
                    SerBuf[1] = 'G';
                    SerBuf[2] = 'S';
                    SerBuf[3] = 'V';
                    SerBuf[4] = '\r';
                    transmit(5);
                    receive();

                    textBox_dcin.Text = new string(SerBuf);
                    stopwatch = System.Diagnostics.Stopwatch.StartNew();
                    for (x = '1'; x < '5'; x++)
                    {
                        SerBuf[0] = ':';    //get output information
                        SerBuf[1] = 'G';
                        SerBuf[2] = 'D';
                        SerBuf[3] = 'O';
                        SerBuf[4] = ',';
                        SerBuf[5] = x;
                        SerBuf[6] = '\r';
                        stopwatch.Restart();
                        transmit(7);
                        receive();
                        stopwatch.Stop();
                        temp[x-49] = stopwatch.ElapsedMilliseconds.ToString();
                        if (new string(SerBuf) == "ACTIVE")
                        {
                            switch (x)
                            {
                                case '1':   button_relay1.BackColor = Color.Red;
                                            break;
                                case '2':   button_relay2.BackColor = Color.Red;
                                            break;
                                case '3':   button_relay3.BackColor = Color.Red;
                                            break;
                                case '4':   button_relay4.BackColor = Color.Red;
                                            break;
                            }

                        }
                        else if (new string(SerBuf) == "INACTIVE")
                            switch (x)
                            {
                                case '1': button_relay1.BackColor = Color.White;
                                    break;
                                case '2': button_relay2.BackColor = Color.White;
                                    break;
                                case '3': button_relay3.BackColor = Color.White;
                                    break;
                                case '4': button_relay4.BackColor = Color.White;
                                    break;
                            }
                    }
                    MessageBox.Show(temp[0].ToString()+','+temp[1].ToString()+','+temp[2].ToString()+','+temp[3].ToString());
                    break;
            }
        }

        private void changeport(object sender, EventArgs e)  //opens a comport
        {
            string[] values;

            module_id = (int)modules.NONE;
            if (BTooth.IsOpen) BTooth.Close();                            // close any existing handle
            BTooth.PortName = comboBox_comport.Text;    // retrieves "COMx" from selection in combo box
            BTooth.Parity = 0;
            BTooth.BaudRate = 19200;
            BTooth.StopBits = StopBits.Two;
            BTooth.DataBits = 8;
            BTooth.ReadTimeout = 1000;
            BTooth.WriteTimeout = 1000;
            BTooth.Open();

            SerBuf[0] = ':';    //get module information
            SerBuf[1] = 'G';
            SerBuf[2] = 'M';
            SerBuf[3] = 'I';
            SerBuf[4] = '\r';
            transmit(5);
            receive();
            if (BTooth.IsOpen) { 
                values = new string(SerBuf).Split(',');
                module_id = Convert.ToByte(values[0]);
                module_version = Convert.ToByte(values[1]);
            }
        }


        private void transmit(byte write_bytes)
        {
            try
            {
                if (BTooth.IsOpen) BTooth.Write(SerBuf, 0, write_bytes);      // writes specified amount of SerBuf out on COM port
            }
            catch (Exception)
            {
                BTooth.Close();
                module_id = (int)modules.NONE;
                MessageBox.Show("write fail");
            }
        }

        private void receive()
        {
            byte x;
            for (x = 0; BTooth.IsOpen; x++)       // this will call the read function for the passed number times, 
            {                                      // this way it ensures each byte has been correctly recieved while
                try                                // still using timeouts
                {
                    BTooth.Read(SerBuf, x, 1);     // retrieves 1 byte at a time and places in SerBuf at position x
                    if (SerBuf[x] == '\r')
                    {
                        SerBuf[x] = '\0';
                        return;
                    }
                }
                catch (Exception)                   // timeout or other error occured, set lost comms indicator
                {
                    BTooth.Close();
                    MessageBox.Show("read fail, failed after " + x.ToString() + " bytes");
                    module_id = (int)modules.NONE;
                }
            }
        }

        private void button_relay1_Click(object sender, EventArgs e)
        {
            if (module_id != (int)modules.NONE)
            {
                SerBuf[0] = ':';
                SerBuf[1] = 'D';
                SerBuf[2] = 'O';
                SerBuf[4] = ',';
                SerBuf[5] = '1';
                SerBuf[6] = ',';
                SerBuf[7] = '1';
                SerBuf[8] = '0';
                SerBuf[9] = '1';
                SerBuf[10] = '\r';

                if (button_relay1.BackColor != Color.Red) SerBuf[3] = 'A';
                else SerBuf[3] = 'I';

                transmit(11);
                receive();
            }
        }

/*
        private void button_relay2_Click(object sender, EventArgs e)
        {
            if (module_id != (int)modules.NONE)
            {
                if (button_relay2.Text == "RELAY 2 ON") SerBuf[0] = 0x21;
                else SerBuf[0] = 0x20;
                SerBuf[1] = 2;
                SerBuf[2] = 0;
                transmit(3);
                receive();
            }
        }

        private void button_relay3_Click(object sender, EventArgs e)
        {
            if (module_id != (int)modules.NONE)
            {
                if (button_relay3.Text == "RELAY 3 ON") SerBuf[0] = 0x21;
                else SerBuf[0] = 0x20;
                SerBuf[1] = 3;
                SerBuf[2] = 0;
                transmit(3);
                receive();
            }
        }

        private void button_relay4_Click(object sender, EventArgs e)
        {
            if (module_id != (int)modules.NONE)
            {
                if (button_relay4.Text == "RELAY 4 ON") SerBuf[0] = 0x21;
                else SerBuf[0] = 0x20;
                SerBuf[1] = 4;
                SerBuf[2] = 0;
                transmit(3);
                receive();
            }
        }*/
    }
}
